IF NOT EXISTS (
    SELECT i.index_id
    FROM sys.indexes i
    JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
    JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
    WHERE 
        i.object_id = OBJECT_ID('dbo.PDV_VD') 
        AND i.type_desc = 'NONCLUSTERED'
        AND (
            (c.name = 'CD_EMP' AND ic.is_included_column = 0)
            OR (c.name = 'CD_FILIAL' AND ic.is_included_column = 0)
            OR (c.name = 'DT_VD' AND ic.is_included_column = 0)
            OR (c.name = 'ST_VD' AND ic.is_included_column = 0)
            OR (c.name = 'VLR_LIQ_VD' AND ic.is_included_column = 1)
            OR (c.name = 'DT_CONSD' AND ic.is_included_column = 1)
            OR (c.name = 'VLR_FRETE_TOT' AND ic.is_included_column = 1)
        )
    GROUP BY i.object_id, i.index_id
    HAVING COUNT(*) = 7
)
BEGIN
    CREATE NONCLUSTERED INDEX IX_PDV_VD_EST_CAIXA_FECHA_ST_VD
	ON [dbo].[PDV_VD] ([CD_EMP],[CD_FILIAL],[DT_VD],[ST_VD])
	INCLUDE ([VLR_LIQ_VD],[DT_CONSD],[VLR_FRETE_TOT]) 
END
